﻿//////////////////////////////////////////////
// ComparisonFunction.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Standards --------------------------------

// nkGraphics
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

/// Enum -------------------------------------

namespace nkGraphics
{
	enum class COMPARISON_FUNCTION
	{
		FUNCTION_NEVER          = 1,
		FUNCTION_LESS           = 2,
		FUNCTION_EQUAL          = 3,
		FUNCTION_LESS_EQUAL     = 4,
		FUNCTION_GREATER        = 5,
		FUNCTION_NOT_EQUAL      = 6,
		FUNCTION_GREATER_EQUAL  = 7,
		FUNCTION_ALWAYS         = 8
	} ;

	class DLL_GRAPHICS_EXPORT ComparisonFunctionUtils final
	{
		public :

			// Conversions
			static nkMemory::StringView toString (COMPARISON_FUNCTION value) ;
			static COMPARISON_FUNCTION fromString (nkMemory::StringView value) ;
			static COMPARISON_FUNCTION fromIndex (unsigned int value) ;
	} ;
}